<?php
$country_list = array(
    'US' => 'United States',
    'CA' => 'Canada',
    'GB' => 'United Kingdom',
    'AF' => 'Afghanistan',
    'AX' => 'Aland Islands',
    'AL' => 'Albania',
    'DZ' => 'Algeria',
    'AS' => 'American Samoa',
    'AD' => 'Andorra',
    'AO' => 'Angola',
    'AI' => 'Anguilla',
    'AQ' => 'Antarctica',
    'AG' => 'Antigua and Barbuda',
    'AR' => 'Argentina',
    'AM' => 'Armenia',
    'AW' => 'Aruba',
    'AU' => 'Australia',
    'AT' => 'Austria',
    'AZ' => 'Azerbaijan',
    'BS' => 'Bahamas',
    'BH' => 'Bahrain',
    'BD' => 'Bangladesh',
    'BB' => 'Barbados',
    'BY' => 'Belarus',
    'BE' => 'Belgium',
    'BZ' => 'Belize',
    'BJ' => 'Benin',
    'BM' => 'Bermuda',
    'BT' => 'Bhutan',
    'BO' => 'Bolivia',
    'BQ' => 'Bonaire, Saint Eustatius and Saba',
    'BA' => 'Bosnia and Herzegovina',
    'BW' => 'Botswana',
    'BV' => 'Bouvet Island',
    'BR' => 'Brazil',
    'IO' => 'British Indian Ocean Territory',
    'VG' => 'British Virgin Islands',
    'BN' => 'Brunei',
    'BG' => 'Bulgaria',
    'BF' => 'Burkina Faso',
    'BI' => 'Burundi',
    'KH' => 'Cambodia',
    'CM' => 'Cameroon',
    'CV' => 'Cape Verde',
    'KY' => 'Cayman Islands',
    'CF' => 'Central African Republic',
    'TD' => 'Chad',
    'CL' => 'Chile',
    'CN' => 'China',
    'CX' => 'Christmas Island',
    'CC' => 'Cocos Islands',
    'CO' => 'Colombia',
    'KM' => 'Comoros',
    'CK' => 'Cook Islands',
    'CR' => 'Costa Rica',
    'HR' => 'Croatia',
    'CU' => 'Cuba',
    'CW' => 'Curacao',
    'CY' => 'Cyprus',
    'CZ' => 'Czech Republic',
    'CD' => 'Democratic Republic of the Congo',
    'DK' => 'Denmark',
    'DJ' => 'Djibouti',
    'DM' => 'Dominica',
    'DO' => 'Dominican Republic',
    'TL' => 'East Timor',
    'EC' => 'Ecuador',
    'EG' => 'Egypt',
    'SV' => 'El Salvador',
    'GQ' => 'Equatorial Guinea',
    'ER' => 'Eritrea',
    'EE' => 'Estonia',
    'ET' => 'Ethiopia',
    'FK' => 'Falkland Islands',
    'FO' => 'Faroe Islands',
    'FJ' => 'Fiji',
    'FI' => 'Finland',
    'FR' => 'France',
    'GF' => 'French Guiana',
    'PF' => 'French Polynesia',
    'TF' => 'French Southern Territories',
    'GA' => 'Gabon',
    'GM' => 'Gambia',
    'GE' => 'Georgia',
    'DE' => 'Germany',
    'GH' => 'Ghana',
    'GI' => 'Gibraltar',
    'GR' => 'Greece',
    'GL' => 'Greenland',
    'GD' => 'Grenada',
    'GP' => 'Guadeloupe',
    'GU' => 'Guam',
    'GT' => 'Guatemala',
    'GG' => 'Guernsey',
    'GN' => 'Guinea',
    'GW' => 'Guinea-Bissau',
    'GY' => 'Guyana',
    'HT' => 'Haiti',
    'HM' => 'Heard Island and McDonald Islands',
    'HN' => 'Honduras',
    'HK' => 'Hong Kong',
    'HU' => 'Hungary',
    'IS' => 'Iceland',
    'IN' => 'India',
    'ID' => 'Indonesia',
    'IR' => 'Iran',
    'IQ' => 'Iraq',
    'IE' => 'Ireland',
    'IM' => 'Isle of Man',
    'IL' => 'Israel',
    'IT' => 'Italy',
    'CI' => 'Ivory Coast',
    'JM' => 'Jamaica',
    'JP' => 'Japan',
    'JE' => 'Jersey',
    'JO' => 'Jordan',
    'KZ' => 'Kazakhstan',
    'KE' => 'Kenya',
    'KI' => 'Kiribati',
    'XK' => 'Kosovo',
    'KW' => 'Kuwait',
    'KG' => 'Kyrgyzstan',
    'LA' => 'Laos',
    'LV' => 'Latvia',
    'LB' => 'Lebanon',
    'LS' => 'Lesotho',
    'LR' => 'Liberia',
    'LY' => 'Libya',
    'LI' => 'Liechtenstein',
    'LT' => 'Lithuania',
    'LU' => 'Luxembourg',
    'MO' => 'Macao',
    'MK' => 'Macedonia',
    'MG' => 'Madagascar',
    'MW' => 'Malawi',
    'MY' => 'Malaysia',
    'MV' => 'Maldives',
    'ML' => 'Mali',
    'MT' => 'Malta',
    'MH' => 'Marshall Islands',
    'MQ' => 'Martinique',
    'MR' => 'Mauritania',
    'MU' => 'Mauritius',
    'YT' => 'Mayotte',
    'MX' => 'Mexico',
    'FM' => 'Micronesia',
    'MD' => 'Moldova',
    'MC' => 'Monaco',
    'MN' => 'Mongolia',
    'ME' => 'Montenegro',
    'MS' => 'Montserrat',
    'MA' => 'Morocco',
    'MZ' => 'Mozambique',
    'MM' => 'Myanmar',
    'NA' => 'Namibia',
    'NR' => 'Nauru',
    'NP' => 'Nepal',
    'NL' => 'Netherlands',
    'NC' => 'New Caledonia',
    'NZ' => 'New Zealand',
    'NI' => 'Nicaragua',
    'NE' => 'Niger',
    'NG' => 'Nigeria',
    'NU' => 'Niue',
    'NF' => 'Norfolk Island',
    'KP' => 'North Korea',
    'MP' => 'Northern Mariana Islands',
    'NO' => 'Norway',
    'OM' => 'Oman',
    'PK' => 'Pakistan',
    'PW' => 'Palau',
    'PS' => 'Palestinian Territory',
    'PA' => 'Panama',
    'PG' => 'Papua New Guinea',
    'PY' => 'Paraguay',
    'PE' => 'Peru',
    'PH' => 'Philippines',
    'PN' => 'Pitcairn',
    'PL' => 'Poland',
    'PT' => 'Portugal',
    'PR' => 'Puerto Rico',
    'QA' => 'Qatar',
    'CG' => 'Republic of the Congo',
    'RE' => 'Reunion',
    'RO' => 'Romania',
    'RU' => 'Russia',
    'RW' => 'Rwanda',
    'BL' => 'Saint Barthelemy',
    'SH' => 'Saint Helena',
    'KN' => 'Saint Kitts and Nevis',
    'LC' => 'Saint Lucia',
    'MF' => 'Saint Martin',
    'PM' => 'Saint Pierre and Miquelon',
    'VC' => 'Saint Vincent and the Grenadines',
    'WS' => 'Samoa',
    'SM' => 'San Marino',
    'ST' => 'Sao Tome and Principe',
    'SA' => 'Saudi Arabia',
    'SN' => 'Senegal',
    'RS' => 'Serbia',
    'SC' => 'Seychelles',
    'SL' => 'Sierra Leone',
    'SG' => 'Singapore',
    'SX' => 'Sint Maarten',
    'SK' => 'Slovakia',
    'SI' => 'Slovenia',
    'SB' => 'Solomon Islands',
    'SO' => 'Somalia',
    'ZA' => 'South Africa',
    'GS' => 'South Georgia and the South Sandwich Islands',
    'KR' => 'South Korea',
    'SS' => 'South Sudan',
    'ES' => 'Spain',
    'LK' => 'Sri Lanka',
    'SD' => 'Sudan',
    'SR' => 'Suriname',
    'SJ' => 'Svalbard and Jan Mayen',
    'SZ' => 'Swaziland',
    'SE' => 'Sweden',
    'CH' => 'Switzerland',
    'SY' => 'Syria',
    'TW' => 'Taiwan',
    'TJ' => 'Tajikistan',
    'TZ' => 'Tanzania',
    'TH' => 'Thailand',
    'TG' => 'Togo',
    'TK' => 'Tokelau',
    'TO' => 'Tonga',
    'TT' => 'Trinidad and Tobago',
    'TN' => 'Tunisia',
    'TR' => 'Turkey',
    'TM' => 'Turkmenistan',
    'TC' => 'Turks and Caicos Islands',
    'TV' => 'Tuvalu',
    'VI' => 'U.S. Virgin Islands',
    'UG' => 'Uganda',
    'UA' => 'Ukraine',
    'AE' => 'United Arab Emirates',
    'UM' => 'United States Minor Outlying Islands',
    'UY' => 'Uruguay',
    'UZ' => 'Uzbekistan',
    'VU' => 'Vanuatu',
    'VA' => 'Vatican',
    'VE' => 'Venezuela',
    'VN' => 'Vietnam',
    'WF' => 'Wallis and Futuna',
    'EH' => 'Western Sahara',
    'YE' => 'Yemen',
    'ZM' => 'Zambia',
    'ZW' => 'Zimbabwe',
);
$incremental_index = time();
$fields = array(
	'nonce' => array(
		'type'  => 'hidden',
		'name'  => 'nonce',
		'label' => '',
		'value' => wp_create_nonce("purchase-direct-{$button_id}"),
		'class' => ''
	),
	'action' => array(
		'type'  => 'hidden',
		'name'  => 'action',
		'label' => '',
		'value' => 'purchase-direct',
		'class' => ''
	),
	'subscription' => array(
		'type'  => 'hidden',
		'name'  => 'recurring',
		'label' => '',
		'value' => $subscription['recurring'],
		'class' => ''
	),
	'redirect_to' => array(
		'type'  => 'hidden',
		'name'  => 'redirect_to',
		'label' => '',
		'value' => get_permalink(),
		'class' => ''
	),
	'id' => array(
		'type'  => 'hidden',
		'name'  => 'id',
		'label' => '',
		'value' => $button_id,
		'class' => ''
	),
	//name fields
    $incremental_index++ => array('type' => 'heading', 'text' => __( 'Personal Information', 'wishlist-member' ) ),
	'first_name' => array(
		'type'        => 'text',
		'name'        => 'first_name',
		'label'       => 'First Name',
		'value'       => $current_user->first_name,
	),
	'last_name' => array(
		'type'        => 'text',
		'name'        => 'last_name',
		'label'       => 'Last Name',
		'value'       => $current_user->last_name,
	),
	'email' => array(
		'type'        => 'text',
		'name'        => 'email',
		'label'       => 'Email',
        'col'     => 'col-12',
		'value'       => $current_user->user_email,
	),
    $incremental_index++ => array('type' => 'break'),

	//card fields
    $incremental_index++ => array('type' => 'heading', 'text' => __( 'Card Details', 'wishlist-member' ) ),
    'cc_fields' => array(
        'type' => 'cc_fields',
        'has' => ['cc_type', 'cc_cvc']
    ),
    $incremental_index++ => array('type' => 'break'),
);

if ( $display_address ) {
	$fields += array(
        $incremental_index++ => array('type' => 'heading', 'text' => __( 'Address', 'wishlist-member' ) ),
        'address' => array(
    		'type'        => 'text',
    		'name'        => 'address',
    		'label'       => 'Address',
    		'value'       => "",
    		'col'    	  => "col-12",
    		'required'       => "",
    	),
    	'city' => array(
    		'type'        => 'text',
    		'name'        => 'city',
    		'label'       => 'City',
    		'value'       => "",
            'col'         => 'col-6',
    		'required'       => "",
    	),
        'state' => array(
    		'type'        => 'text',
    		'name'        => 'state',
    		'label'       => 'State/Province',
    		'value'       => "",
            'col'         => 'col-3 col-6-sm',
    	),
        'zip' => array(
    		'type'        => 'text',
    		'name'        => 'zip',
    		'label'       => 'Zip/Postal',
    		'value'       => "",
            'col'         => 'col-3 col-6-sm',
    		'required'       => "",
    	),
        'country' => array(
    		'type'        => 'select',
    		'name'        => 'country',
    		'label'       => 'Country',
    		'value'       => $country_list,
            'col'         => 'col-12',
    	),
        $incremental_index++ => array('type' => 'break'),
    );
}

$data['id']                 = $button_id;
$data['fields']             = $fields;
$data['form_action']        = $anetarbthankyou_url;
$data['logo']               = $logo;
$data['heading']            = $this->process_form_codes( $formheading, $codes);
$data['panel_button_label'] = $this->process_form_codes( $formbuttonlabel, $codes);
$data['panel_beforetext']   = $this->process_form_codes( $beforetext, $codes);
$data['panel_aftertext']    = $this->process_form_codes( $aftertext, $codes);

if($subscription['recurring']) {
    $s = $subscription;
    $frequency = _n( $s['recur_billing_period'], '%d ' . $s['recur_billing_period'] . 's', $s['recur_billing_frequency'], 'wishlist-member' );
    $frequency = sprintf($frequency, $s['recur_billing_frequency']);

    $trial = '';
    if((float) $s['trial_amount'] && (int) $s['trial_billing_cycle']) {
        $installment = sprintf(_n('%d installment', '%d installments', $s['trial_billing_cycle'], 'wishlist-member'), $s['trial_billing_cycle']);
        $trial = sprintf(__('%.2f %s every %s for %s <br>Then ', 'wishlist-member'), $s['trial_amount'], $s['currency'], $frequency, $installment);
    }
    $cycle = (int) $s['recur_billing_cycle'];
    $installment = $cycle ? sprintf(_n(' for %d installment', ' for %d installments', $s['recur_billing_cycle'], 'wishlist-member'), $cycle) : '';
    $data['payment_description'] = sprintf(__('%s%.2f %s every %s%s', 'wishlist-member'), $trial, $s['recur_amount'], $s['currency'], $frequency, $installment);

} else {
    $data['payment_description'] = sprintf('%s %.2f', $codes['currency'], $codes['amount']);
}

$data['sc_details'] = $codes;

$data['card_types']         = $card_types;
